/*
 * 쐬: 2007/10/11
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFEclipse Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ext.jdt;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;


/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends AbstractUIPlugin {
	
	public static String LINE_SEP = System.getProperty("line.separator"); //$NON-NLS-1$
	
	public static final String TITLE = "ZIGEN's DBViewer Plugin"; //$NON-NLS-1$
	
	public static final String VERSION = "1.0.4 release 2009/01/08"; //$NON-NLS-1$
	
	public static final String PLUGIN_ID = "zigen.plugin.db.ext.jdt"; //$NON-NLS-1$
	
	private static Activator plugin;
	
	private String defaultProject = null;
	
	
	/**
	 * The constructor
	 */
	public Activator() {
		plugin = this;
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}
	
	private static String getPluginId() {
		return getDefault().getBundle().getSymbolicName();
	}
	
	/**
	 * Returns the shared instance
	 * 
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}
	
	// pbP[WI_CAOOpen̏WJvWFNg擾
	public String getDefaultProject() {
		return defaultProject;
	}
	
	// pbP[WI_CAOOpen̏WJvWFNg̐ݒ
	public void setDefaultProject(String defaultProject) {
		this.defaultProject = defaultProject;
	}
	
	public IWorkbenchPage getPage() {
		IWorkbench workbench = PlatformUI.getWorkbench();
		IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
		return window.getActivePage();
	}
	
	public Shell getShell() {
		IWorkbench workbench = PlatformUI.getWorkbench();
		IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
		return window.getShell();
	}
	
	public static IStatus createWarningStatus(Throwable throwable) {
		return createWarningStatus(-1, throwable);
	}
	
	public static void log(IStatus status) {
		getDefault().getLog().log(status);
	}
	
	public static IStatus createErrorStatus(Throwable throwable) {
		return createErrorStatus(-1, throwable);
	}
	
	private static String getErrorMessage(Throwable throwable) {
		if (throwable != null) {
			String msg = throwable.getMessage();
			if (msg == null) {
				return getErrorMessage(throwable.getCause());
			} else {
				return msg;
			}
		} else {
			return Messages.getString("Activator.0"); //$NON-NLS-1$
		}
	}
	
	
	static IStatus createWarningStatus(int errorCode, Throwable throwable) {
		String msg = getErrorMessage(throwable);
		// bZ[W͍ŏ̉s܂łɕ\
		int endIndex = msg.indexOf(Activator.LINE_SEP);
		if (endIndex > 0) {
			msg = msg.substring(0, endIndex);
		}
		return new Status(IStatus.WARNING, getPluginId(), errorCode, msg, null);
	}
	
	static IStatus createErrorStatus(int errorCode, Throwable throwable) {
		String msg = getErrorMessage(throwable);
		// bZ[W͍ŏ̉s܂łɕ\
		int endIndex = msg.indexOf(Activator.LINE_SEP);
		if (endIndex > 0) {
			msg = msg.substring(0, endIndex);
		}
		return new Status(IStatus.ERROR, getPluginId(), errorCode, msg, throwable);
	}
	
	public void showErrorDialog(Throwable throwable) {
		String message = Messages.getString("Activator.1"); //$NON-NLS-1$
		IStatus status = null;
		if (throwable instanceof SQLException) {
			status = createWarningStatus(throwable);
		} else {
			status = createErrorStatus(throwable);
		}
		
		ErrorDialog.openError(getShell(), Activator.TITLE, message, status);
		
	}
	
	public static void log(String message, Exception e) {
		IStatus status = new Status(IStatus.ERROR, getPluginId(), IStatus.ERROR, message, e);
		getDefault().getLog().log(status);
	}
	
	public static void log(Exception e) {
		StringWriter stringWriter = new StringWriter();
		e.printStackTrace(new PrintWriter(stringWriter));
		String message = stringWriter.getBuffer().toString();
		log(message, e);
		
		// for debug
		if (e != null)
			e.printStackTrace();
	}
}
